//=================================================
//A very specialized mutator that allows 
//=================================================
class MSFunServerMutator expands Mutator config(MSFunServer);

var const config String Summons[256];
var const config String Packages[32];
var const config EPackageIcon PackageIcons[32];
var const Texture IconTypes[9];

enum EPackageIcon
{
	IconDeusEx,
	IconDecoration,
	IconPawn,
	IconPickup,
	IconGadget,
	IconWeapon,
	IconAmmo,
	IconCombo,
	IconMisc
};

function PostBeginPlay()
{   
	Level.Game.BaseMutator.AddMutator(Self);
	Level.Game.RegisterDamageMutator(Self);
}

simulated function ShowMessage(DeusExPlayer Player, string Message)
{
  local HUDMissionStartTextDisplay    HUD;

  if ((Player.RootWindow != None) && (DeusExRootWindow(Player.RootWindow).HUD != None))
  {
    HUD = DeusExRootWindow(Player.RootWindow).HUD.startDisplay;
  }
  if(HUD != None)
  {
    HUD.shadowDist = 0;
    HUD.Message = "";
    HUD.charIndex = 0;
    HUD.winText.SetText("");
    HUD.winTextShadow.SetText("");
    HUD.displayTime = 5.50;
    HUD.perCharDelay = 0.30;
    HUD.AddMessage(Message);
    HUD.StartMessage();
  }
}

function string GetPackage(int i, Out Texture Tex)
{
 local string S;
 local int J;
 
 S = Packages[i];
 
 J = int(PackageIcons[i]);
 
 Tex = IconTypes[j];
 
 return S;
}

function GiveCatalogue(DeusExPlayer P)
{
 local DeusExPlayer P;
 local DeusExRootWindow Root;
 local SummonCatalogueWindow SummonWindow;
 
 if (P == None) return;
 
 if(P != None)
 {
  P.InitRootWindow();
  Root = DeusExRootWindow(P.rootWindow);
  
  if(Root != None)
  {
   SummonWindow = SummonCatalogueWindow(Root.InvokeMenuScreen(Class'SummonCatalogueWindow', True));
   
   if(SummonWindow != None)
   {
    SummonWindow.Mutator = Self;
    SummonWindow.CreateSummonList();
   }
  }
 }
}

function bool IsValidEntry(String S)
{
 local int i;
 local bool b;
 
 for(i=0; i<256; i++)
 {
  if (Summons[i] ~= "") break;
  
  if (Summons[i] ~= S && S != "") b = True;
 }
 
 return b;
}

function ProcessSummon(String S, DeusEXPlayer P)
{
 local string TempS;
 local class<Actor> SumType;
 
 TempS = CAPS(S);
 
 if (InStr(TempS, ".") == -1)
 {
  TempS = "DEUSEX."$TempS;
 }
 
 if (IsValidEntry(TempS))
 {
  SumType = class<Actor>(DynamicLoadObject(TempS, Class'Class'));
  if (SumType != None) DoSummon(P, SumType);
 }
 
 if (!IsValidEntry(TempS) || SumType == None)
 {
  P.ClientMessage("Invalid or prohibited actor class "$Chr(34)$TempS$Chr(34));
 }
}

function DoSummon(DeusExPlayer P, class<Actor> SumType)
{
 local Actor A;
 
 A = Spawn( SumType,,,P.Location + (P.CollisionRadius + SumType.Default.CollisionRadius+30) * Vector(P.Rotation) + vect(0,0,1) * 15 );
 
 if (A != None)
 {
  BroadcastMessage(P.PlayerReplicationInfo.PlayerName$"("$P.PlayerReplicationInfo.PlayerID$") Summoned a(n) "$SumType);
  
  if (A.IsA('Inventory')) Inventory(A).RespawnTime = 0;
  if (A.IsA('DeusExWeapon'))
  {
   DeusExWeapon(A).bWeaponStay = False;
   DeusExWeapon(A).mpHitDamage = 0;
   DeusExWeapon(A).hitDamage = 0;
   DeusExWeapon(A).PostBeginPlay();
  }
  if (A.IsA('ScriptedPawn')) ScriptedPawn(A).bInvincible = False;
  if (A.IsA('DeusExDecoration'))
  {
   if (DeusExDecoration(A).bInvinicible)
   {
    DeusExDecoration(A).bInvincible = False;
    DeusExDecoration(A).hitPoints = 250;
   }
   if (DeusExDecoration(A).bExplosive)
   {
    DeusExDecoration(A).ExplosionDamage = 0;
   }
  }
 }
}

function Mutate(string S, PlayerPawn Player)
{
 local DeusExMPGame A;
 local int i, j;
 local string STrim;
 
 if (S ~= "Catalogue")
 {
  GiveCatalogue(DeusExPlayer(Player));
 }
 if ( InStr(CAPS(S) "SUMMON" > -1) )
 {
  ProcessSummon(S, DeusExPlayer(Player));
 }
 
 Super.Mutate(S, Player);
}



defaultproperties
{
 IconTypes(0)=Texture'PackageIconDX'
 IconTypes(1)=Texture'PackageIconDecoration'
 IconTypes(2)=Texture'PackageIconPawn'
 IconTypes(3)=Texture'PackageIconPickup'
 IconTypes(4)=Texture'PackageIconGadget'
 IconTypes(5)=Texture'PackageIconWeapon'
 IconTypes(6)=Texture'PackageIconAmmo'
 IconTypes(7)=Texture'PackageIconCombo'
 IconTypes(8)=Texture'PackageIconMisc'
}
